<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <style>
        #text{
            font-family: Arial, Helvetica, sans-serif;
            font-size: 14px;
        }
        #table {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 12px;
            border-collapse: collapse;
            width: 100%;
        }

        #table td, #table th {
            border: 1px solid #ddd;
            padding: 8px;
        }

        #table tr:nth-child(even){background-color: #f2f2f2;}

        #table tr:hover {background-color: #ddd;}

        #table th {
            padding-top: 12px;
            padding-bottom: 12px;
            text-align: left;
            background-color: #00ADBB;
            color: white;
            font-size: 12px;
        }
    </style>
</head>
<body>

<img src="{{ $logo }}" width="120"/><br><br>

<h2>{{ $user->fname }} {{ $user->lname }}</h2>
<p id="text">As at <strong>{{ date('l jS \of F Y h:i:s A') }}</strong></p>

<table id="table" cellspacing="0" width="100%">
    <thead>
    <tr>
        <th width="">
            Transaction Date
        </th>
        <th width="">
            Reference Number
        </th>
        <th width="">
            Description
        </th>
        <th width="">
            Credit Balance
        </th>
        <th width="">
            Debit
        </th>
        <th width="">
            Credit
        </th>
    </tr>
    </thead>

    <tbody>
    @if($transactions)
        @foreach($transactions as $trans)
            <tr>
                <td width="">
                    {{date('jS \of F Y', strtotime($trans->created_at))}}
                </td>
                <td width="">
                    {{ $trans->ref }}
                </td>
                <td width="">
                    {{ $trans->description }}
                </td>
                <td width="">
                    ${{ number_format($trans->currbal, 0) }}
                </td>
                <td width="">
                    {{ !empty($trans->debit) ? '$'.number_format($trans->debit, 0):'' }}
                </td>
                <td width="">
                    {{ !empty($trans->credit) ? '$'.number_format($trans->credit, 0):'' }}
                </td>
            </tr>
        @endforeach
    @endif

    </tbody>
</table>

</body>
</html>
