<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <title>Registration Complete &mdash; Heritage Capital Union</title>

    <!-- META SECTION -->
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="shortcut icon" href="<?php echo e(asset('bank_logoonly.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('bank_logoonly.png')); ?>" type="image/x-icon">
    <!-- END META SECTION -->

    <!-- CSS INCLUDE -->
    <link rel="stylesheet" href="<?php echo e(asset('auth/css/styles2c70.css?v=1.0.3')); ?>">
    <!-- EOF CSS INCLUDE -->
</head>

<body>
<!-- PAGE WRAPPER -->
<div class="page">
    <!-- PAGE CONTENT WRAPPER -->
    <div class="page__content" id="page-content">
        <!-- PAGE CONTENT CONTAINER -->
        <div class="content d-none d-lg-block" id="content" style="background: url( <?php echo e(asset('auth/assets/img/backgrounds/bridge.jpg')); ?> ) left center no-repeat; background-size: 100% auto"></div>
        <!-- //END PAGE CONTENT CONTAINER -->
        <!-- PAGE LOGIN CONTAINER -->
        <div class="important-container login-container">

            <div class="content text-lg-center">
                <?php echo $__env->make('includes.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <a style="margin-bottom:80px;" href="<?php echo e(url('/')); ?>" class="logo-holder logo-holder--lg logo-holder--wide">
                    <div class="logo-text">
                        <img src="<?php echo e(asset('bank_logo.png')); ?>" width="150"/>
                    </div>
                </a>

                <h1>Registration Complete</h1>
                <h3>Thank you <?php echo e(Session::get('firstname')); ?> <?php echo e(Session::get('lastname')); ?> for Opening an account with us</h3>
                <p>Your account will be active after approval</p>

                <div class="divider"></div>
                <div class="form-group text-center">
                    <div class="form-row">
                        <div class="col-4"><a href="<?php echo e(url('/')); ?>" class="text-muted">Home</a></div>
                        <div class="col-4"><a href="<?php echo e(route('login')); ?>" class="text-muted">Login</a></div>
                        <div class="col-4">info@heritagecapitalunion.com</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- PAGE LOGIN CONTAINER -->
    </div>
    <!-- //END PAGE CONTENT -->
</div>
<!-- //END PAGE WRAPPER -->

<!-- IMPORTANT SCRIPTS -->
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/jquery/jquery.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/jquery/jquery-migrate.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/bootstrap/bootstrap.bundle.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/mcustomscrollbar/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
<!-- END IMPORTANT SCRIPTS -->

<!-- TEMPLATE SCRIPTS -->
<script type="text/javascript" src="<?php echo e(asset('auth/js/app.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/plugins.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/demo.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/settings.js')); ?>"></script>
<!-- END TEMPLATE SCRIPTS -->
</body>

</html>
<?php /**PATH /home/ocearhxe/public_html/bank.oceaniccapitalventures.com/resources/views/registration-complete.blade.php ENDPATH**/ ?>